const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");
const { getSystemTime } = require("../functions/serverTime");
const moment = require("moment-timezone");

module.exports.createDefectReason = async (req, res) => {
  try {
    const { defect } = req.body;
    const duplicateRecord = await performQuery(
      `Select * from ${tables.defects} Where defect = ?`,
      [defect]
    );

    if (duplicateRecord.length > 0) {
      return sendErrorResponse(res, 409, "Record Already Exists", 409);
    }
    const currentDate = await getSystemTime();
    const currentTime = moment(currentDate).format("YYYY-MM-DD HH:mm:ss");

    const query = `INSERT INTO ${tables.defects} 
        SET ?`;
    const params = {
      defect: defect,
      created_at: currentTime,
      created_by: req?.user?.id,
    };
    const data = await performQuery(query, params);

    if (data.insertId > 0) {
      return sendResponse(res, data, "created successfully", 201);
    }
    return sendErrorResponse(res, 400, "Error in Creating Defect Reason", 400);
  } catch (error) {
    return sendErrorResponse(res, error, "Error in Create Defect Reason API");
  }
};

module.exports.getDefectReasons = async (req, res) => {
  try {
    const query = `SELECT * FROM ${tables.defects}`;
    const data = await performQuery(query);
    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "selected Successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error getting defect reasons API");
  }
};

module.exports.updateDefectReason = async (req, res) => {
  try {
    const { id, defect } = req.body;

    const duplicateRecord = await performQuery(
      `Select * from ${tables.defects} 
          Where defect = ? and id <> ?`,
      [defect, id]
    );

    if (duplicateRecord.length > 0) {
      return sendErrorResponse(res, 409, "Record Already Exists", 409);
    }
    const currentDate = await getSystemTime();
    const currentTime = moment(currentDate).format("YYYY-MM-DD HH:mm:ss");

    const query = `UPDATE ${tables.defects} 
        SET ? 
        WHERE 
        id=?`;

    const params = [
      {
        defect: defect,
        updated_at: currentTime,
        updated_by: req?.user?.id,
      },
      id,
    ];
    const data = await performQuery(query, params);

    if (data.affectedRows > 0) {
      return sendResponse(res, data, "Updated Successfully", 200);
    }

    return sendErrorResponse(res, 400, "Error in Updating Defect Reason", 400);
  } catch (error) {
    return sendErrorResponse(res, error, "Error updating Defect reason");
  }
};
module.exports.deleteDefectReason = async (req, res) => {
  try {
    const { id } = req.body;

    const query = `DELETE FROM ${tables.defects} WHERE id=?`;
    const data = await performQuery(query, [id]);

    if (data.affectedRows > 0) {
      return sendResponse(res, data, "Deleted Successfully", 200);
    }

    return sendErrorResponse(res, 400, "Error in Deleting Defect Reason", 400);
  } catch (error) {
    return sendErrorResponse(res, error, "Error deleting Defect reason");
  }
};
