const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");

module.exports.getFilteredEvents = async (req, res) => {
  try {
    const { order_start, order_end, line_id } = req.body;
    const query = `
    SELECT 
      e.id, e.line_id, l.line, e.shift_id, sh.shift_name, e.order_id, o.order_no,
      o.product_id, p.product_code, p.product_name,
      e.event_name, e.start_time, e.end_time, e.duration,
      e.stop_id, s.stop_start, s.main_stop_id, s.stop_end, s.downtime,
      s.downtime_reason_id, dr.category, dr.sub_category, dr.detail_level_1, 
      dr.detail_level_2, dr.detail_level_3, dr.detail_level_4, 
      s.equipment_id, s.sub_equipment_id, s.comment,	
      e.user_id, u.name
    FROM ${tables.events} e
      LEFT JOIN ${tables.line} l ON e.line_id = l.id
      LEFT JOIN ${tables.shift} sh ON e.shift_id = sh.id
      LEFT JOIN ${tables.orders} o ON e.order_id = o.id
      LEFT JOIN ${tables.product} p ON o.product_id = p.id
      LEFT JOIN ${tables.stops} s ON e.stop_id = s.id or (e.stop_id = s.main_stop_id and e.stop_id <> 0)
      LEFT JOIN ${tables.downtime_reasons} dr ON s.downtime_reason_id = dr.id
      LEFT JOIN ${tables.users} u ON e.user_id = u.id
    WHERE 
      STR_TO_DATE(e.start_time, '%Y-%m-%d %H:%i:%s') >= STR_TO_DATE('${order_start}', '%Y-%m-%d %H:%i:%s') 
      AND STR_TO_DATE(e.start_time, '%Y-%m-%d %H:%i:%s') < STR_TO_DATE('${order_end}', '%Y-%m-%d %H:%i:%s') 
      ${line_id ? `AND e.line_id = '${line_id}'` : ""}
    ORDER BY 
      e.id DESC`;
    
    const data = await performQuery(query);
    if (data.length === 0) {
      return sendResponse(res, [], "No events found", 200);
    }
    return sendResponse(res, data, "Selected Successfully", 200);
  } catch (error) {
    console.log("Error: ", error);
    
    return sendErrorResponse(res, error, "Error getting Filtered events");
  }
};