const express = require("express");
const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");

module.exports.createScrap = async (req, res) => {
  try {
    const {
      order_detail_id,
      re1,
      re2,
      re3,
      re4,
      re5,
      re6,
      re7,
      re8,
      re9,
      re10,
      re11,
      re12,
      re13,
      re14,
      re15,
      re16,
      re17,
      re18,
      re19,
      re20,
    } = req.body;

    const data = await performQuery(
      `SELECT * FROM ${tables.scrap} WHERE order_detail_id=?`,
      [order_detail_id]
    );

    if (data.length > 0) {
      // Scrap against this PO exists
      const data = await performQuery(
        `Update ${tables.scrap}
                SET ?
                Where order_detail_id=?`,
        [
          {
            re1: re1 || 0,
            re2: re2 || 0,
            re3: re3 || 0,
            re4: re4 || 0,
            re5: re5 || 0,
            re6: re6 || 0,
            re7: re7 || 0,
            re8: re8 || 0,
            re9: re9 || 0,
            re10: re10 || 0,
            re11: re11 || 0,
            re12: re12 || 0,
            re13: re13 || 0,
            re14: re14 || 0,
            re15: re15 || 0,
            re16: re16 || 0,
            re17: re17 || 0,
            re18: re18 || 0,
            re19: re19 || 0,
            re20: re20 || 0,
          },
          order_detail_id,
        ]
      );

      if (data.affectedRows > 0) {
        return sendResponse(res, data, "Scrap updated successfully", 201);
      }
      return sendErrorResponse(res, 400, "Error in updating Scrap", 400);
    } else {
      // No Scrap registered
      const Insertquery = `INSERT INTO ${tables.scrap} SET ? `;
      const params = {
        order_detail_id: order_detail_id,
        re1: re1 || 0,
        re2: re2 || 0,
        re3: re3 || 0,
        re4: re4 || 0,
        re5: re5 || 0,
        re6: re6 || 0,
        re7: re7 || 0,
        re8: re8 || 0,
        re9: re9 || 0,
        re10: re10 || 0,
        re11: re11 || 0,
        re12: re12 || 0,
        re13: re13 || 0,
        re14: re14 || 0,
        re15: re15 || 0,
        re16: re16 || 0,
        re17: re17 || 0,
        re18: re18 || 0,
        re19: re19 || 0,
        re20: re20 || 0,
      };
      const data = await performQuery(Insertquery, params);

      if (data.insertId > 0) {
        return sendResponse(res, data, "Scrap Inserted successfully", 201);
      }
      return sendErrorResponse(res, 400, "Error in Inserting Scrap", 400);
    }
  } catch (error) {
    console.log("error: ", error);
    return sendErrorResponse(res, error, "Error creating Scrap");
  }
};
module.exports.getScrap = async (req, res) => {
  try {
    const query = `SELECT * FROM ${tables.scrap}`;
    const data = await performQuery(query);
    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "Select Data successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error getting Scrap");
  }
};
module.exports.getSpecificScrap = async (req, res) => {
  try {
    const order_detail_id = req.query.order_detail_id;
    const query = `SELECT * FROM ${tables.scrap} Where order_detail_id='${order_detail_id}'`;
    const data = await performQuery(query);
    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "Select Data successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error getting Scrap");
  }
};
