const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");
const { getSystemTime } = require("../functions/serverTime");
const moment = require("moment-timezone");

module.exports.splitStop = async (req, res) => {
  try {
    // console.log("req.body >>", req.body);
    const {
      id,
      stop_end,
      downtime_reason_id,
      equipment_id,
      sub_equipment_id,
      comment,
    } = req.body;

    // Validations
    if (!id) {
      return sendErrorResponse(res, 400, "Stop ID is required", 400);
    }

    const currentDate = await getSystemTime();
    const currentTime = moment(currentDate).format("YYYY-MM-DD HH:mm:ss");

    // Get Main Stop Details
    const mainStopData = await performQuery(
      `SELECT * FROM ${tables.stops} WHERE id=${id}`
    );
    if (mainStopData.length === 0) {
      return sendErrorResponse(res, 400, "Main Stop not found", 400);
    }
    const mainStop = mainStopData[0];

    // get Downtime Reasons
    const downtimeReasonData = await performQuery(
      `SELECT * FROM ${tables.downtime_reasons} WHERE id=${downtime_reason_id}`
    );
    if (downtime_reason_id > 0 && downtimeReasonData.length === 0) {
      return sendErrorResponse(res, 400, "Downtime Reason not found", 400);
    }
    const downtimeReason = downtimeReasonData?.[0];
    
    const newStop = { ...mainStop }; // shallow copy
    newStop.stop_end = stop_end;
    newStop.downtime = moment(stop_end).diff(moment(newStop.stop_start), "seconds");
    newStop.main_stop_id = id;
    newStop.downtime_reason_id = downtime_reason_id;
    newStop.stop_category = downtime_reason_id == 0 ? "Unreported" : downtimeReason?.category || null;
    newStop.stop_sub_category = downtime_reason_id == 0 ? "Unreported" : downtimeReason?.sub_category || null;
    newStop.stop_detail_level_1 = downtimeReason?.detail_level_1 || null; 
    newStop.stop_detail_level_2 = downtimeReason?.detail_level_2 || null; 
    newStop.stop_detail_level_3 = downtimeReason?.detail_level_3 || null;
    newStop.stop_detail_level_4 = downtimeReason?.detail_level_4 || null;
    newStop.equipment_id = equipment_id || null;
    newStop.sub_equipment_id = sub_equipment_id || null;
    newStop.comment = comment || null;
    
    mainStop.stop_start = stop_end;
    mainStop.downtime = moment(mainStop.stop_end).diff(moment(mainStop.stop_start), "seconds");
        
    const insertSplitedStop = await performQuery(
      `INSERT INTO ${tables.stops} SET ?`,
      {
        main_stop_id: newStop.main_stop_id,
        line_id: newStop.line_id,
        shift_id: newStop.shift_id,
        order_id: newStop.order_id,
        user_id: newStop.user_id,
        device_data_id: newStop.device_data_id,
        order_detail_id: newStop.order_detail_id,
        stop_start: newStop.stop_start,
        stop_end: newStop.stop_end,
        downtime: newStop.downtime,
        downtime_reason_id: newStop.downtime_reason_id || 0,
        stop_category: newStop.stop_category,
        stop_sub_category: newStop.stop_sub_category,
        stop_detail_level_1: newStop.stop_detail_level_1, 
        stop_detail_level_2: newStop.stop_detail_level_2, 
        stop_detail_level_3: newStop.stop_detail_level_3,
        stop_detail_level_4: newStop.stop_detail_level_4, 
        equipment_id: newStop.equipment_id || 0,
        sub_equipment_id: newStop.sub_equipment_id || 0,
        status: "Completed",
        comment: newStop.comment,
        created_at: currentTime,
        created_by: req?.user?.id,
        updated_at: currentTime,
        updated_by: req?.user?.id,
      }
    );

    if (insertSplitedStop.insertId > 0) {
      const updateMainStop = await performQuery(
        `UPDATE ${tables.stops} SET ? WHERE id=?`,
        [
          {
            stop_start: mainStop.stop_start,
            downtime: mainStop.downtime,
            updated_at: currentTime,
            updated_by: req?.user?.id,
          },
          mainStop.id,
        ]
      );

      if (updateMainStop.affectedRows > 0) {
        return sendResponse(res, insertSplitedStop, "Stop Splited Successfully", 200);
      }

      return sendErrorResponse(res, 400, "Error in Spliting Stop", 400);
    }
    return sendErrorResponse(res, 400, "Error in Spliting Stop");
  } catch (error) {
    console.log("Error in Create Stop: ", error);
    return sendErrorResponse(res, error, "Error creating stops");
  }
};

module.exports.updateStop = async (req, res) => {
  try {
    const {
      id,
      downtime_reason_id,
      equipment_id,
      sub_equipment_id,
      comment,
    } = req.body;

    // Validations
    if (!id) {
      return sendErrorResponse(res, 400, "Stop ID is required", 400);
    }
    
    // Get Main Stop Details
    const mainStopData = await performQuery(
      `SELECT * FROM ${tables.stops} WHERE id=${id}`
    );
    if (mainStopData.length === 0) {
      return sendErrorResponse(res, 400, "Main Stop not found", 400);
    }

    // get Downtime Reasons
    const downtimeReasonData = await performQuery(
      `SELECT * FROM ${tables.downtime_reasons} WHERE id=${downtime_reason_id}`
    );
    if (downtime_reason_id > 0 && downtimeReasonData.length === 0) {
      return sendErrorResponse(res, 400, "Downtime Reason not found", 400);
    }
    const downtimeReason = downtimeReasonData[0];
    console.log("Downtime Reason: ", downtimeReason);
    

    const data = await performQuery(
      `UPDATE ${tables.stops} SET ? WHERE id = ?`, [{
        downtime_reason_id: downtime_reason_id || 0,
        stop_category: downtimeReason.category,
        stop_sub_category: downtimeReason.sub_category,
        stop_detail_level_1: downtimeReason.detail_level_1,
        stop_detail_level_2: downtimeReason.detail_level_2,
        stop_detail_level_3: downtimeReason.detail_level_3,
        stop_detail_level_4: downtimeReason.detail_level_4,
        equipment_id: equipment_id || 0,
        sub_equipment_id: sub_equipment_id || 0,
        comment: comment,
      }, id]);
    if (data.affectedRows > 0) {
      return sendResponse(res, data, "Stop Updated Successfully", 200);
    }
    return sendErrorResponse(res, 400, "Error in Updating Stop", 400);
  } catch (error) {
    console.log("Error in update Stop: ", error);
    return sendErrorResponse(res, error, "Error updating stops");
  }
};
module.exports.filteredStops = async (req, res) => {
  try {
    const {
      line_id, start_time, end_time, timestamp, isUnreported, order_detail_id
    } = req.query;

    let query = `
      SELECT 
          s.*, e.equipment, se.sub_equipment
      FROM ${tables.stops} AS s
      LEFT JOIN ${tables.equipment} AS e ON s.equipment_id = e.id
      LEFT JOIN ${tables.sub_equipment} AS se ON s.sub_equipment_id = se.id
      WHERE 1=1
    `;

    if (line_id) {
      query += ` AND s.line_id = "${line_id}" `;
    }
    if (isUnreported && isUnreported == 1) {
      query += ` AND s.downtime_reason_id = 0 `;
    }
    if (timestamp) {
      query += ` 
                AND STR_TO_DATE(s.stop_start, '%Y-%m-%d %H:%i:%s') <= STR_TO_DATE('${timestamp}', '%Y-%m-%d %H:%i:%s') 
                AND STR_TO_DATE(s.stop_end, '%Y-%m-%d %H:%i:%s') >= STR_TO_DATE('${timestamp}', '%Y-%m-%d %H:%i:%s')`;
    }
    if (start_time && end_time) {
      query += ` 
                AND STR_TO_DATE(s.stop_start, '%Y-%m-%d %H:%i:%s') >= STR_TO_DATE('${start_time}', '%Y-%m-%d %H:%i:%s') 
                AND STR_TO_DATE(s.stop_end, '%Y-%m-%d %H:%i:%s') <= STR_TO_DATE('${end_time}', '%Y-%m-%d %H:%i:%s')`;
    }
    if (order_detail_id) {
      query += ` AND s.order_detail_id = ${order_detail_id} `;
    }
    query += ` ORDER BY s.id DESC `;

    const result = await performQuery(query);
    if (result.length === 0) {
      return sendResponse(res, result, "No Stop Found", 200);
    }
    return sendResponse(res, result, "Stop Found", 200);
  } catch (error) {
    console.log("Error in filtered Stops: ", error);
    return sendErrorResponse(res, error, "Error getting stops");
  }
};
