// cache.js
const NodeCache = require("node-cache");

// Create a cache instance with default options
const cache = new NodeCache({ stdTTL: 300, checkperiod: 120 });

module.exports = {
  // Set a value in the cache
  set: (key, value, ttl = null) => {
    return cache.set(key, value, ttl);
  },

  // Get a value from the cache
  get: (key) => {
    return cache.get(key);
  },

  // Check if a key exists in the cache
  has: (key) => {
    return cache.has(key);
  },

  // Delete a key from the cache
  del: (key) => {
    return cache.del(key);
  },

  // Clear all cache
  flush: () => {
    return cache.flushAll();
  },

  // Get cache stats
  stats: () => {
    return cache.getStats();
  },
};
