const moment = require("moment");

const getDownTime = (deviceData) => {
  let downTimeOne = [];
  let downTime = [];

  let deviceDetails = {
    machineOffTime1: false,
    machineOnTime1: false,
    machineOffTime2: false,
    machineOnTime2: false,
    machineOffTime3: false,
    machineOnTime3: false,
    machineOffTime4: false,
    machineOnTime4: false,
    line_nameOne: "",
    deviceIdOne: "",
    line_nameTwo: "",
    deviceIdTwo: "",
    line_nameThree: "",
    deviceIdThree: "",
    line_nameFour: "",
    deviceIdFour: "",
  };

  deviceData.forEach((item, index, arr) => {
    // console.log("item >>>", item);
    if (item.data.deviceStatus === 0) {
      // Condition For Machine OFF
      if (
        !deviceDetails.machineOffTime1 &&
        item.data.line_name !== deviceDetails.line_nameTwo &&
        item.data.line_name !== deviceDetails.line_nameThree &&
        item.data.line_name !== deviceDetails.line_nameFour
      ) {
        deviceDetails.machineOffTime1 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();
        deviceDetails.line_nameOne = item.data.line_name;
        deviceDetails.deviceIdOne = item.data.id;
      } else if (
        deviceDetails.machineOffTime1 &&
        !deviceDetails.machineOffTime2 &&
        item.data.line_name !== deviceDetails.line_nameOne &&
        item.data.line_name !== deviceDetails.line_nameThree &&
        item.data.line_name !== deviceDetails.line_nameFour
      ) {
        deviceDetails.machineOffTime2 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();
        deviceDetails.line_nameTwo = item.data.line_name;
        deviceDetails.deviceIdTwo = item.data.id;
      } else if (
        deviceDetails.machineOffTime1 &&
        deviceDetails.machineOffTime2 &&
        !deviceDetails.machineOffTime3 &&
        item.data.line_name !== deviceDetails.line_nameOne &&
        item.data.line_name !== deviceDetails.line_nameTwo &&
        item.data.line_name !== deviceDetails.line_nameFour
      ) {
        deviceDetails.machineOffTime3 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();
        deviceDetails.line_nameThree = item.data.line_name;
        deviceDetails.deviceIdThree = item.data.id;
      } else if (
        deviceDetails.machineOffTime1 &&
        deviceDetails.machineOffTime2 &&
        deviceDetails.machineOffTime3 &&
        !deviceDetails.machineOffTime4 &&
        item.data.line_name !== deviceDetails.line_nameOne &&
        item.data.line_name !== deviceDetails.line_nameTwo &&
        item.data.line_name !== deviceDetails.line_nameThree
      ) {
        deviceDetails.machineOffTime4 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();
        deviceDetails.line_nameFour = item.data.line_name;
        deviceDetails.deviceIdFour = item.data.id;
      }
    } else if (item.data.deviceStatus === 1) {
      if (
        deviceDetails.machineOffTime1 !== false &&
        item.data.line_name === deviceDetails.line_nameOne
      ) {
        deviceDetails.machineOnTime1 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();

        let downTimeTemp =
          Date.parse(deviceDetails.machineOnTime1) -
          Date.parse(deviceDetails.machineOffTime1);
        downTimeTemp = Math.ceil(downTimeTemp / 1000);

        downTimeOne.push({
          machineOffTime1: deviceDetails.machineOffTime1,
          machineOnTime1: deviceDetails.machineOnTime1,
          line_nameOne: deviceDetails.line_nameOne,
          deviceIdOne: deviceDetails.deviceIdOne,
          downTimeTemp,
        });

        deviceDetails = {
          machineOffTime1: false,
          machineOnTime1: false,
          machineOffTime2: deviceDetails.machineOffTime2,
          machineOnTime2: deviceDetails.machineOnTime2,
          machineOffTime3: deviceDetails.machineOffTime3,
          machineOnTime3: deviceDetails.machineOnTime3,
          machineOffTime4: deviceDetails.machineOffTime4,
          machineOnTime4: deviceDetails.machineOnTime4,
          line_nameOne: "",
          deviceIdOne: "",
          line_nameTwo: deviceDetails.line_nameTwo,
          deviceIdTwo: deviceDetails.deviceIdTwo,
          line_nameThree: deviceDetails.line_nameThree,
          deviceIdThree: deviceDetails.deviceIdThree,
          line_nameFour: deviceDetails.line_nameFour,
          deviceIdFour: deviceDetails.deviceIdFour,
        };
      } else if (
        deviceDetails.machineOffTime2 !== false &&
        item.data.line_name === deviceDetails.line_nameTwo
      ) {
        deviceDetails.machineOnTime2 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();

        let downTimeTemp =
          Date.parse(deviceDetails.machineOnTime2) -
          Date.parse(deviceDetails.machineOffTime2);
        downTimeTemp = Math.ceil(downTimeTemp / 1000);

        downTimeOne.push({
          machineOffTime2: deviceDetails.machineOffTime2,
          machineOnTime2: deviceDetails.machineOnTime2,
          line_nameTwo: deviceDetails.line_nameTwo,
          deviceIdTwo: deviceDetails.deviceIdTwo,
          downTimeTemp,
        });

        deviceDetails = {
          machineOffTime1: deviceDetails.machineOffTime1,
          machineOnTime1: deviceDetails.machineOnTime1,
          machineOffTime2: false,
          machineOnTime2: false,
          machineOffTime3: deviceDetails.machineOffTime3,
          machineOnTime3: deviceDetails.machineOnTime3,
          machineOffTime4: deviceDetails.machineOffTime4,
          machineOnTime4: deviceDetails.machineOnTime4,
          line_nameOne: deviceDetails.line_nameOne,
          deviceIdOne: deviceDetails.deviceIdOne,
          line_nameTwo: "",
          deviceIdTwo: "",
          line_nameThree: deviceDetails.line_nameThree,
          deviceIdThree: deviceDetails.deviceIdThree,
          line_nameFour: deviceDetails.line_nameFour,
          deviceIdFour: deviceDetails.deviceIdFour,
        };
      } else if (
        deviceDetails.machineOffTime3 !== false &&
        item.data.line_name === deviceDetails.line_nameThree
      ) {
        deviceDetails.machineOnTime3 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();

        let downTimeTemp =
          Date.parse(deviceDetails.machineOnTime3) -
          Date.parse(deviceDetails.machineOffTime3);
        downTimeTemp = Math.ceil(downTimeTemp / 1000);

        downTimeOne.push({
          machineOffTime3: deviceDetails.machineOffTime3,
          machineOnTime3: deviceDetails.machineOnTime3,
          line_nameThree: deviceDetails.line_nameThree,
          deviceIdThree: deviceDetails.deviceIdThree,
          downTimeTemp,
        });

        deviceDetails = {
          machineOffTime1: deviceDetails.machineOffTime1,
          machineOnTime1: deviceDetails.machineOnTime1,
          machineOffTime2: deviceDetails.machineOffTime2,
          machineOnTime2: deviceDetails.machineOnTime2,
          machineOffTime3: false,
          machineOnTime3: false,
          machineOffTime4: deviceDetails.machineOffTime4,
          machineOnTime4: deviceDetails.machineOnTime4,
          line_nameOne: deviceDetails.line_nameOne,
          deviceIdOne: deviceDetails.deviceIdOne,
          line_nameTwo: deviceDetails.line_nameTwo,
          deviceIdTwo: deviceDetails.deviceIdTwo,
          line_nameThree: "",
          deviceIdThree: "",
          line_nameFour: deviceDetails.line_nameFour,
          deviceIdFour: deviceDetails.deviceIdFour,
        };
      } else if (
        deviceDetails.machineOffTime4 !== false &&
        item.data.line_name === deviceDetails.line_nameFour
      ) {
        deviceDetails.machineOnTime4 = moment
          .utc(item.data.timestamp, "MM/DD/YYYY HH:mm:ss")
          .toISOString();

        let downTimeTemp =
          Date.parse(deviceDetails.machineOnTime4) -
          Date.parse(deviceDetails.machineOffTime4);
        downTimeTemp = Math.ceil(downTimeTemp / 1000);

        downTimeOne.push({
          machineOffTime4: deviceDetails.machineOffTime4,
          machineOnTime4: deviceDetails.machineOnTime4,
          line_nameFour: deviceDetails.line_nameFour,
          deviceIdFour: deviceDetails.deviceIdFour,
          downTimeTemp,
        });

        deviceDetails = {
          machineOffTime1: deviceDetails.machineOffTime1,
          machineOnTime1: deviceDetails.machineOnTime1,
          machineOffTime2: deviceDetails.machineOffTime2,
          machineOnTime2: deviceDetails.machineOnTime2,
          machineOffTime3: deviceDetails.machineOffTime3,
          machineOnTime3: deviceDetails.machineOnTime3,
          machineOffTime4: false,
          machineOnTime4: false,
          line_nameOne: deviceDetails.line_nameOne,
          deviceIdOne: deviceDetails.deviceIdOne,
          line_nameTwo: deviceDetails.line_nameTwo,
          deviceIdTwo: deviceDetails.deviceIdTwo,
          line_nameThree: deviceDetails.line_nameThree,
          deviceIdThree: deviceDetails.deviceIdThree,
          line_nameFour: "",
          deviceIdFour: "",
        };
      }
    }
  });

  for (let index = 0; index < downTimeOne.length; index++) {
    downTime.push(downTimeOne[index].downTimeTemp);
  }

  // console.log("downTime >>>", downTime);
  // console.log("downTimeOne >>>", downTimeOne);
  const totalDownTime = downTime.reduce((a, b) => a + b, 0);
  // console.log("totalDownTime >>>", totalDownTime);

  return {
    downTimeOne: downTimeOne,
    downTime: downTime,
    totalDownTime: totalDownTime,
  };
  // return [
  //     downTimeOne,
  //     downTime,
  //     [
  //       {
  //         totalDownTime: totalDownTime,
  //       },
  //     ],
  //   ];
};

module.exports = { getDownTime };
