const db = require("./db");

// Wraps the pool.getConnection() function
function getConnection() {
  return new Promise((resolve, reject) => {
    db.getConnection((err, connection) => {
      if (err) {
        reject(err);
        return;
      }

      resolve(connection);
    });
  });
}

// Performs a database query using a connection from the pool
async function performQuery(sql, params) {
  const connection = await getConnection();

  try {
    return new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) {
          reject(error);
          return;
        }
        resolve(results);
      });
    });
  } finally {
    connection.release();
  }
}

module.exports = { getConnection, performQuery };
